//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function []=%CLquat_p(q)

// LAST UPDATE
// 03/05/2007
//
// Authors
// CNES - DCT/SB
//

// Declarations:


// Code:

N=size(q);
if isempty(N) N=0; end,
fprintf(%io(2),"type quaternion dim = %d",N);
fprintf(%io(2),"----------------------------------------------");
if N>3
  fprintf(%io(2),"real part=  [%f,%f,...,%f]",q.r(1),q.r(2),q.r($));
  fprintf(%io(2),"imag. part= [%f,%f,...,%f]",q.i(1,1),q.i(1,2),q.i(1,$));
  fprintf(%io(2),"            [%f,%f,...,%f]",q.i(2,1),q.i(2,2),q.i(2,$));
  fprintf(%io(2),"            [%f,%f,...,%f]",q.i(3,1),q.i(3,2),q.i(3,$));
elseif N==3
  fprintf(%io(2),"real part=  [%f,%f,%f]",q.r(1),q.r(2),q.r(3));
  fprintf(%io(2),"imag. part= [%f,%f,%f]",q.i(1,1),q.i(1,2),q.i(1,3));
  fprintf(%io(2),"            [%f,%f,%f]",q.i(2,1),q.i(2,2),q.i(2,3));
  fprintf(%io(2),"            [%f,%f,%f]",q.i(3,1),q.i(3,2),q.i(3,3));
elseif N==2
  fprintf(%io(2),"real part=  [%f,%f]",q.r(1),q.r(2));
  fprintf(%io(2),"imag. part= [%f,%f]",q.i(1,1),q.i(1,2));
  fprintf(%io(2),"            [%f,%f]",q.i(2,1),q.i(2,2));
  fprintf(%io(2),"            [%f,%f]",q.i(3,1),q.i(3,2));
elseif N==1
  fprintf(%io(2),"real part=  %f",q.r);
  fprintf(%io(2),"imag. part= %f",q.i(1,1));
  fprintf(%io(2),"            %f",q.i(2,1));
  fprintf(%io(2),"            %f",q.i(3,1));
end

endfunction
